float4x4 WVP : WORLDVIEWPROJECTION;
float4x4 World : WORLD;
float4 Kolor : COLOR = float4(1,1,0,1);

float4 Ce : COLOR = float4(0,0,0,1);
float4 Ca : COLOR = float4(0.5,0.1,0.1,1);
float4 Cd : COLOR = float4(1,1,1,1);

float4 Wa = float4(1,1,1,1);
float4 Wd = float4(1,1,1,1);

float3 PozycjaZrodlaSwiatla = float3(1,1,1);

struct Dane_PozycjaNormalnaWspTeksturowania
{
	float4 Polozenie : POSITION0;
	float3 Normalna : NORMAL0;
	float2 WspTeksturowania : TEXCOORD0;
};

struct Dane_PozycjaKolor
{
	float4 Polozenie : POSITION0;
	float4 Kolor : COLOR0;
};

//Dane_PozycjaKolor VS(float4 Polozenie : POSITION0)
Dane_PozycjaKolor VS(Dane_PozycjaNormalnaWspTeksturowania input)
{
	Dane_PozycjaKolor output;
	output.Polozenie=mul(input.Polozenie,WVP);
	//output.Kolor.rgb=abs(input.Normalna);
	//output.Kolor.a=1;

	float3 R=mul(input.Polozenie,World).xyz;
	float3 L=normalize(PozycjaZrodlaSwiatla-R);
	float3 N=mul(input.Normalna,World);
	float dotLN=saturate(dot(L,N));	

	output.Kolor=saturate(Ce);
	output.Kolor+=saturate(Wa*Ca);
	output.Kolor+=saturate(Wd*Cd*dotLN);
	output.Kolor=saturate(output.Kolor);

	return output;
}

float4 PS(Dane_PozycjaKolor input) : COLOR0
{
	return input.Kolor;
}

Technique technika
{
	Pass przebieg
	{
		VertexShader = compile vs_2_0 VS();
		PixelShader = compile ps_2_0 PS();
	}
}